% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_Shapefile.R
\name{Get_Shapefile}
\alias{Get_Shapefile}
\title{Download the boundaries of NUTS-3 (Provinces) and LAU (Municipalities) Italian administrative units from the ISTAT website}
\source{
<https://www.istat.it/it/archivio/222527>
}
\usage{
Get_Shapefile(Year, level = "LAU", lightShp = TRUE)
}
\arguments{
\item{Year}{Numeric value. Reference year for the administrative units.}

\item{level}{Character. Either \code{"NUTS-3"}, \code{"Province"}, \code{"LAU"}, \code{"Municipality"}. \code{"LAU"} by default}

\item{lightShp}{Logical. If \code{TRUE}, the function downloads a generalised, i.e.less detailed, and lighter version of the shapefiles.
\code{TRUE} by default.}
}
\value{
A spatial data frame of class \code{data.frame} and \code{sf}.
}
\description{
'
}
\examples{

\donttest{
  library(magrittr)


  Prov23_shp <- Get_Shapefile(2023, lightShp = TRUE, level = "NUTS-3")
  ggplot2::ggplot() + ggplot2::geom_sf(data = Prov23_shp) +
    ggplot2::ggtitle("Italian provinces in 2023/01/01")
 }


}
