% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Util_DB_MIUR_num.R
\name{Util_DB_MIUR_num}
\alias{Util_DB_MIUR_num}
\title{Convert the raw school buildings data to numeric or Boolean variables}
\usage{
Util_DB_MIUR_num(
  data = NULL,
  include_numerics = TRUE,
  include_qualitatives = FALSE,
  row_cutout = FALSE,
  track_deleted = TRUE,
  verbose = TRUE,
  col_cut_thresh = 20000,
  unique_buildings = TRUE,
  flag_outliers = TRUE,
  autoAbort = FALSE,
  ...
)
}
\arguments{
\item{data}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}. Input data obtained through the function \code{\link{Get_DB_MIUR}}.
If \code{NULL} it will be downloaded automatically with the appropriate arguments, but not saved in the global environment. \code{NULL} by default.}

\item{include_numerics}{Logical. Whether to include strictly numeric variables alongside with Boolean ones. \code{TRUE} by default.}

\item{include_qualitatives}{Logical. Whether to include qualitative variables alongside with Boolean ones. \code{FALSE} by default.}

\item{row_cutout}{Logical. Whether to filter out rows including missing fields. \code{FALSE} by default.}

\item{track_deleted}{Logical. If \code{TRUE}, the function returns the names of the schools not included in the output dataframe. \code{TRUE} by default.}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. TRUE by default.}

\item{col_cut_thresh}{Numeric. The threshold of missing values allowed for each variable.
If a variable as a higher number of missing observations, then it is cut out. \code{20.000} by default.
Warning: if the option \code{row_cutout} is active, please select a lower threshold (e.g. \code{1000})}

\item{unique_buildings}{Logical. Whether to remove records in which the building code is duplicated and all other fields are as well.
As rows are combinations of building ID and school ID, if a school is hosted by several buildings, and each field other than
\code{School_code} are duplicated, then only one row is retained. \code{TRUE} by default.}

\item{flag_outliers}{Logical. Whether to assign NA to outliers in numeric variables. \code{TRUE} by default.}

\item{autoAbort}{Logical. In case any data must be retrieved, whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}

\item{...}{Additional arguments to the function \code{Get_DB_MIUR} if \code{data} is not provided.}
}
\value{
If \code{track_deleted == TRUE}, An object of class \code{list} including two objects:
\itemize{
  \item \code{$data}: object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, the output dataframe.
  \item \code{$deleted}: object of class \code{tbl_df}, \code{tbl} and \code{data.frame}. The school IDs of the deleted units.
}

If \code{track_deleted == FALSE}, the output is only the first element of the list.
}
\description{
This function transforms the output variables of the \code{\link{Get_DB_MIUR}} into Boolean or Numeric.
Additionally, it removes the columns with an excessive number of missing observations (20.000 by default), and if required it may also delete the rows including missing fields.
 In this case, it is possible to keep track of the deleted rows.
}
\details{
The outliers to be set to \code{NA} if \code{flag_outliers} is active are defined as follows: School area or free area surface of less than 50 squared meters,
building volume of less than 150 cubic meters, 0 floors in the building.
}
\examples{

library(magrittr)

DB23_MIUR_num <- example_input_DB23_MIUR \%>\% Util_DB_MIUR_num(track_deleted = FALSE)


DB23_MIUR_num[, -c(1,4,6,8,9,10)]
summary(DB23_MIUR_num)


}
