% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ln.R
\docType{data}
\name{ln}
\alias{ln}
\alias{ln1p}
\alias{lg}
\alias{lg1p}
\alias{E}
\alias{lb}
\title{Logarithms.}
\format{An object of class \code{numeric} of length 1.}
\usage{
ln(x)

ln1p()

lg()

lg1p(x)

E

lb()
}
\arguments{
\item{x}{A numeric or complex vector.}
}
\description{
To avoid confusion using the default \code{log()} function, which is natural
logarithm, but spells out like base 10 logarithm in the mind of some
beginneRs, we define \code{ln()} and \code{ln1p()} as wrappers for \code{log()`` with default}base = exp(1)\code{argument and for}log1p()\code{, respectively. For similar reasons,}lg()\code{is a wrapper of}log10()\code{(there is no possible confusion here, but 'lg' is another common notation for base 10 logarithm).}lg1p()\code{is a convenient way to use the optimized code to calculate the logarithm of x + 1, but returning the result in base 10 logarithm.}E\code{is the Euler constant and is provided for convenience as}exp(1)\code{. Finally}lb()\code{is a synonym of}log2()`.
}
\examples{
ln(exp(3))              # Same as log(exp(3))
ln1p(c(0, 1, 10, 100))  # Wrapper for log1p()
lg(10^3)                # Same as log10(10^3)
lg1p(c(0, 1, 10, 100))  # log10(x + 1), but optimized for x << 1
E^4                     # Similar to exp(4), but different calculation!
lb(1:3)                 # Wrapper for log2()
}
\seealso{
\code{\link[=log]{log()}}
}
\concept{
logarithms and exponentials
}
\keyword{datasets}
\keyword{math}
