% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\encoding{UTF-8}
\name{bonett.seier}
\alias{bonett.seier}
\title{Bonett-Seier test of Geary's kurtosis}
\usage{
bonett.seier(x, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{x}{A numeric vector of data values.}

\item{alternative}{A character string specifying the alternative hypothesis,
 must be one of '"two.sided"' (default), '"greater"' or '"less"'.
  You can specify just the initial letter}
}
\description{
Performs the Bonett-Seier test of Geary's measure of kurtosis for normally distributed data.
}
\details{
Under the hypothesis of normality, data should have Geary's
   kurtosis equal to \code{sqrt(2/pi)} (0.7979). This test has such null
    hypothesis and is useful to detect a significant difference of Geary's
     kurtosis in normally distributed data.
}
\examples{
set.seed(1234)
x = rnorm(1000)
geary(x)
bonett.seier(x)
}
\references{
Bonett, D.G., Seier, E. (2002) A test of normality with high uniform power. Computational Statistics and Data Analysis, 40, 435-445.
}
\keyword{Tests}

