% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geom_foot.R
\encoding{UTF-8}
\name{plotTitleSubtitle}
\alias{plotTitleSubtitle}
\title{Add Title and Subtitle to a ggplot Object}
\usage{
plotTitleSubtitle(title, subtitle = "")
}
\arguments{
\item{title}{A character string as title.}

\item{subtitle}{A character string as subtitle.}
}
\description{
A production function to make it easy to add title and subtitle to \pkg{ggplot2} objects.
}
\examples{
# setup data
set.seed(51)
supply <- rnorm(100,mean=15-seq(1,6,by=.05),sd=1)
demand <- rnorm(100,mean=4+seq(1,21,by=.2),sd=.5)
time<-seq(1,100,by=1)
data <- data.frame(time, supply,demand)

# make the plot
library(ggplot2)
ggplot(data,aes(time)) +
geom_line(aes(y=demand),size=1.6) +
geom_line(aes(y=supply),size=1.6) +
annotate("text",x=90,y=12,label="Demand",colour="red") +
annotate("text",x=80,y=23,label="Supply",colour="blue") +
plotTitleSubtitle("My Title", "My Subtitle")
}

