% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagrams.R
\name{roc_curve_vec}
\alias{roc_curve_vec}
\title{ROC curves}
\usage{
roc_curve_vec(probs, obs, interpolate = TRUE)
}
\arguments{
\item{probs}{vector with probabilities (between 0 and 1)}

\item{obs}{vector with categorical observations}

\item{interpolate}{logical. If TRUE the ROC-curve is interpolated and drawn as a continuous function. Otherwise it is drawn as a step function.}
}
\value{
a gg object
}
\description{
Plot the ROC-curve for a vector of probabilities and corresponding observations.
}
\examples{
probs = seq(0,1,length.out = 5)
obs = c(FALSE,FALSE,TRUE,FALSE,TRUE)
pp = roc_curve_vec(probs,obs)
if(interactive()) plot(pp)

}
