% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoboost.R
\name{trajC0}
\alias{trajC0}
\alias{trajC0.selectboost}
\title{Plot trajectories}
\usage{
trajC0(x, ...)

\method{trajC0}{selectboost}(
  x,
  summary.selectboost.res,
  lasso.coef.path,
  type.x.axis = "noscale",
  type.graph = "boost",
  threshold.level = NULL,
  ...
)
}
\arguments{
\item{x}{Numerical matrix. Selectboost object.}

\item{...}{. Passed to the plotting functions.}

\item{summary.selectboost.res}{List. Summary of selectboost object.}

\item{lasso.coef.path}{List. Result of \code{predict.lars}.}

\item{type.x.axis}{Character value. "scale" or "noscale" for the X axis.}

\item{type.graph}{Character value. Type of graphs: "bars", "lasso" and "boost".}

\item{threshold.level}{Numeric value. Threshold for the graphs.}
}
\value{
An invisible list.

invisible list.
}
\description{
Plot trajectories.
}
\details{
\code{trajC0} returns an invisible list and creates four graphics.
}
\examples{

data(autoboost.res.x)
data(diabetes, package="lars")

### With lasso trajectories
m.x<-lars::lars(diabetes$x,diabetes$y)
plot(m.x)
mm.x<-predict(m.x,type="coef",mode="lambda")
autoboost.res.x.mean = summary(autoboost.res.x)

par(mfrow=c(2,2),mar=c(4,4,1,1))
trajC0(autoboost.res.x,autoboost.res.x.mean,lasso.coef.path=mm.x,type.graph="lasso")
trajC0(autoboost.res.x,autoboost.res.x.mean)
trajC0(autoboost.res.x,autoboost.res.x.mean,type.graph="bars")
trajC0(autoboost.res.x,autoboost.res.x.mean,type.x.axis ="scale")

}
\references{
\emph{selectBoost: a general algorithm to enhance the performance of variable selection methods in correlated datasets}, Frédéric Bertrand, Ismaïl Aouadi, Nicolas Jung, Raphael Carapito, Laurent Vallat, Seiamak Bahram, Myriam Maumy-Bertrand, Bioinformatics, 2020. \doi{10.1093/bioinformatics/btaa855}
}
\seealso{
\code{\link{fastboost}}, \code{\link{autoboost}} and \code{\link{summary.selectboost}}

Other Selectboost analyze functions: 
\code{\link{auto.analyze}()},
\code{\link{plot.summary.selectboost}()}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@utt.fr}
}
\concept{Selectboost analyze functions}
