% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partboot.test.R
\name{partboot.test}
\alias{partboot.test}
\title{Statistical tests for \code{\link[SemNeT]{partboot}}}
\usage{
partboot.test(..., formula = NULL, groups = NULL)
}
\arguments{
\item{...}{Object(s) from \code{\link[SemNeT]{partboot}}}

\item{formula}{Character.
A formula for specifying an ANOVA structure. The formula should
have the predictor variable as "y" and include the names the variables
are grouped by (e.g., \code{formula = "y ~ group_var1 * group_var2"}).
See Two-way ANOVA example in examples}

\item{groups}{Data frame.
A data frame specifying the groups to be input into the formula.
The column names should be the variable names of interest. The
groups should be in the same order as the groups input into
\code{\link[SemNeT]{partboot}}}
}
\value{
Returns a list containing the objects:

\item{ASPL}{Test statistics for each percentage of nodes remaining for ASPL}

\item{CC}{Test statistics for each percentage of nodes remaining for CC}

\item{Q}{Test statistics for each percentage of nodes remaining for Q}

If two groups:

A matrix in each object has the following columns:

\item{t-statistic}{Statistic from the \code{\link{t.test}}}

\item{df}{Degrees of freedom}

\item{p-value}{\emph{p}-value with values equal to \code{0} being \emph{p} < .001}

\item{d}{Cohen's \emph{d}}

\item{CI95.lower}{Lower bound of the 95 percent confidence interval}

\item{CI95.upper}{Upper bound of the 95 percent confidence interval}

\item{Direction}{Direction of the effect. The argument \code{groups} will
specify specifically which group is higher or lower on the measure. If no
groups are input, then \code{"d"} and \code{"p"} are used to represent
\code{data} and \code{paired} samples from \code{\link[SemNeT]{partboot}}, respectively}

Row names refer to the percentage of nodes remaining in bootstrapped networks

If three or more groups:

A list containing two objects:

\item{ANOVA}{A matrix containing the \emph{F}-statistic, group degrees of freedom,
residual degrees of freedom, \emph{p}-value, and partial eta squared {\code{p.eta.sq}}}

\item{HSD}{A matrix containing the differences between each group (\code{diff}),
lower (\code{lwr}) and upper (\code{upr}) bounds of the 95\% confidence interval,
and the adjusted \emph{p}-value (\code{p.adj})}
}
\description{
Computes statistical tests for partial bootstrapped
networks from \code{\link[SemNeT]{partboot}}. Automatically
computes \emph{t}-tests (\code{\link{t.test}}) or ANOVA
(\code{\link{aov}}) including Tukey's HSD for pairwise comparisons
(\code{\link{TukeyHSD}})
}
\examples{
# Simulate Dataset
one <- sim.fluency(20)
two <- sim.fluency(20)
\donttest{
# Run partial bootstrap networks
two.result <- partboot(one, two, percent = .50, iter = 1000,
sim = "cosine", cores = 2)
}
# Compute tests
partboot.test(two.result)

\donttest{
# Two-way ANOVA example
## Simulated data
hihi <- sim.fluency(50, 500)
hilo <- sim.fluency(50, 500)
lohi <- sim.fluency(50, 500)
lolo <- sim.fluency(50, 500)

## Create groups
hihi.group <- cbind(rep("high",nrow(hihi)),rep("high",nrow(hihi)))
hilo.group <- cbind(rep("high",nrow(hilo)),rep("low",nrow(hilo)))
lohi.group <- cbind(rep("low",nrow(lohi)),rep("high",nrow(lohi)))
lolo.group <- cbind(rep("low",nrow(lolo)),rep("low",nrow(lolo)))

## Bind groups into single data frame
groups <- rbind(hihi.group,
                hilo.group,
                lohi.group,
                lolo.group)

## Change column names (variable names)
colnames(groups) <- c("gf","caq")

## Change groups into data frame
groups <- as.data.frame(groups)

## Run partial bootstrap networks
boot.fifty <- partboot(hihi, hilo, lohi, lolo, percent = .50)
boot.sixty <- partboot(hihi, hilo, lohi, lolo, percent = .60)

## Compute tests
partboot.test(boot.fifty, boot.sixty, formula = "y ~ gf*caq", groups = groups)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
