% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.partboot.R
\name{plot.partboot}
\alias{plot.partboot}
\title{Plot for partboot}
\usage{
\method{plot}{partboot}(..., groups = NULL, measures = c("ASPL", "CC", "Q"))
}
\arguments{
\item{...}{Object(s) from \code{\link[SemNeT]{partboot}}}

\item{groups}{Character.
Labels for groups in the order they were entered
in \code{\link[SemNeT]{partboot}}}

\item{measures}{Character.
Measures to be plotted}
}
\value{
Returns plots for the specified measures
}
\description{
Bootstraps (without replacement) the nodes in the network and computes global network characteristics
}
\examples{
# Simulate Dataset
one <- sim.fluency(20)
\donttest{
# Run partial bootstrap networks
one.result <- partboot(one, percent = .50, iter = 1000,
sim = "cosine", cores = 2)
}
# Plot
plot(one.result, groups = c("One"))

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
