% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pluralize.R
\name{pluralize}
\alias{pluralize}
\title{Converts Words to their Plural Form}
\usage{
pluralize(word)
}
\arguments{
\item{word}{A word}
}
\value{
Returns the word in singular form
}
\description{
A function to pluralize words.
The rules for converting words to their plural forms
are based on the grammar rules found here:
\href{https://www.grammarly.com/blog/plural-nouns/}{https://www.grammarly.com/blog/plural-nouns/}.
This function does not handle special cases, so particular care is necessary.
}
\examples{
"dog"
trial[1,1]

"dogs"
pluralize(trial[1,1])

"fox"
trial[15,1]

"foxes"
pluralize(trial[15,1])

"wolf"
trial[14,2]

"wolves"
pluralize(trial[14,2])

"octopi"
pluralize("octopus")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
