% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.dictionaries.R
\name{load.dictionaries}
\alias{load.dictionaries}
\title{Load Dictionaries}
\usage{
load.dictionaries(dictionary)
}
\arguments{
\item{dictionary}{Character vector.
Dictionaries to load.

\code{\link[SemNetDictionaries]{dictionaries}} will identify dictionaries in \code{\link{SemNetDictionaries}}

\code{\link[SemNetDictionaries]{find.dictionaries}} will identify dictionaries on your computer}
}
\value{
Returns a vector of words that has been combined
and alphabetized from specified dictionaries
}
\description{
A wrapper function for to load text dictionaries into
\code{\link{SemNetCleaner}}. Searches for dictionaries in 
\code{\link{SemNetDictionaries}} and on your computer. Outputs 
a word list that is combined from all dictionaries entered 
in the \code{dictionary} argument
}
\examples{
#find dictionaries to load
dictionaries()

#load "animals" dictionary
load.dictionaries("animals")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
