% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm.R
\name{gen_gaussian}
\alias{gen_gaussian}
\title{Generate observations from a Gaussian graphical model.}
\usage{
gen_gaussian(n, ...)
}
\arguments{
\item{n}{The number of samples to generate. If multiple networks are provided,
n samples are generated per network.}

\item{...}{The 'network' object(s) to generate data from. Can be a single
network, many networks, or a single list of networks.}
}
\value{
A list containing the n by p matrix of samples and the 'network'
object used to generate them.
}
\description{
Generates data based on the multivariate normal distribution parameterized by
a zero mean vector and a covariance matrix. Observations are generated for
each module in the network individually, and the covariance matrix is set to
the inverse of the standardized association matrix for the module.
Observations are combined for gene i by taking the sum across the m_i modules
containing it and dividing by sqrt(m_i).
}
\examples{
nw <- random_network(10) # Create a random network with 10 nodes.
nw <- gen_partial_correlations(nw) # Add weights to connections in the network.
x <- gen_gaussian(20, nw)$x # Simulate 20 Gaussian observations from network. 
}
\references{
\insertRef{grimes21}{SeqNet}
}
