% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{FindMarkersNode}
\alias{FindMarkersNode}
\title{Gene expression markers of identity classes defined by a phylogenetic clade}
\usage{
FindMarkersNode(object, node, tree.use = NULL, genes.use = NULL,
  thresh.use = 0.25, test.use = "bimod", ...)
}
\arguments{
\item{object}{Seurat object}

\item{node}{The node in the phylogenetic tree to use as a branch point}

\item{tree.use}{Can optionally pass the tree to be used. Default uses the tree in object@cluster.tree}

\item{genes.use}{Genes to test. Default is to use all genes}

\item{thresh.use}{Limit testing to genes which show, on average, at least
X-fold difference (log-scale) between the two groups of cells. Default is 0.25
Increasing thresh.use speeds up the function, but can miss weaker signals.}

\item{test.use}{Denotes which test to use. Seurat currently implements
"bimod" (likelihood-ratio test for single cell gene expression, McDavid et
al., Bioinformatics, 2013, default), "roc" (standard AUC classifier), "t"
(Students t-test), and "tobit" (Tobit-test for differential gene expression,
as in Trapnell et al., Nature Biotech, 2014), 'poisson', and 'negbinom'.
The latter two options should only be used on UMI datasets, and assume an underlying
poisson or negative-binomial distribution}

\item{...}{Additional arguments passed to FindMarkers}
}
\value{
Matrix containing a ranked list of putative markers, and associated
statistics (p-values, ROC score, etc.)
}
\description{
Finds markers (differentially expressed genes) based on a branching point (node) in
the phylogenetic tree. Markers that define clusters in the left branch are positive markers.
Markers that define the right branch are negative markers.
}
\examples{
FindMarkersNode(pbmc_small, 5)

}
