% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{VizPCA}
\alias{VizPCA}
\title{Visualize PCA genes}
\usage{
VizPCA(object, pcs.use = 1:5, num.genes = 30, use.full = FALSE,
  font.size = 0.5, nCol = NULL, do.balanced = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{pcs.use}{Number of PCs to display}

\item{num.genes}{Number of genes to display}

\item{use.full}{Use full PCA (i.e. the projected PCA, by default FALSE)}

\item{font.size}{Font size}

\item{nCol}{Number of columns to display}

\item{do.balanced}{Return an equal number of genes with both + and - PC scores.
If FALSE (by default), returns the top genes ranked by the score's absolute values}
}
\value{
Graphical, no return value
}
\description{
Visualize top genes associated with principal components
}
\examples{
VizPCA(object = pbmc_small)

}
