% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_app.R
\name{theme_app}
\alias{theme_app}
\title{Complete theme for \code{ShinyItemAnalysis} graphics}
\usage{
theme_app(base_size = 15, base_family = "")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\description{
This complete theme is based on \code{theme_bw} and it was modified for purposes
of \code{ShinyItemAnalysis}.
}
\examples{
\dontrun{
data(GMAT)
data <- GMAT[, 1:20]
# total score calculation
df <- data.frame(score = apply(data, 1, sum))
# histogram
g <- ggplot(df, aes(score)) +
geom_histogram(binwidth = 1) +
xlab("Total score") +
ylab("Number of respondents")

g
g + theme_app()
}
}
\seealso{
\code{\link[ggplot2]{ggtheme}}
}
