% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{GetMotifObject}
\alias{GetMotifObject}
\alias{GetMotifObject.Assay}
\alias{GetMotifObject.Seurat}
\title{Retrieve a Motif object}
\usage{
GetMotifObject(object, ...)

\method{GetMotifObject}{Assay}(object, ...)

\method{GetMotifObject}{Seurat}(object, assay = NULL, ...)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Arguments passed to other methods}

\item{assay}{Which assay to use. Default is the current active assay}
}
\value{
Returns a \code{\link{Motif}} object
}
\description{
Get motif object from given assay
}
\examples{
GetMotifObject(object = atac_small[['peaks']])
GetMotifObject(object = atac_small)
}
