% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{CoveragePlot}
\alias{CoveragePlot}
\title{Plot Tn5 insertion frequency over a region}
\usage{
CoveragePlot(
  object,
  region,
  features = NULL,
  assay = NULL,
  show.bulk = FALSE,
  expression.assay = "RNA",
  expression.slot = "data",
  annotation = TRUE,
  peaks = TRUE,
  ranges = NULL,
  ranges.title = "Ranges",
  links = TRUE,
  tile = FALSE,
  tile.size = 100,
  tile.cells = 100,
  heights = NULL,
  group.by = NULL,
  window = 100,
  extend.upstream = 0,
  extend.downstream = 0,
  scale.factor = NULL,
  ymax = NULL,
  cells = NULL,
  idents = NULL,
  sep = c("-", "-"),
  max.downsample = 3000,
  downsample.rate = 0.1,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{region}{A set of genomic coordinates to show. Can be a GRanges object,
a string encoding a genomic position, a gene name, or a vector of strings
describing the genomic coordinates or gene names to plot. If a gene name is
supplied, annotations must be present in the assay.}

\item{features}{A vector of features present in another assay to plot
alongside accessibility tracks (for example, gene names).}

\item{assay}{Name of the assay to plot}

\item{show.bulk}{Include coverage track for all cells combined (pseudo-bulk).
Note that this will plot the combined accessibility for all cells included in
the plot (rather than all cells in the object).}

\item{expression.assay}{Name of the assay containing expression data to plot
alongside accessibility tracks. Only needed if supplying \code{features}
argument.}

\item{expression.slot}{Name of slot to pull expression data from. Only needed
if supplying the \code{features} argument.}

\item{annotation}{Display gene annotations}

\item{peaks}{Display peaks}

\item{ranges}{Additional genomic ranges to plot}

\item{ranges.title}{Y-axis title for ranges track. Only relevant if
\code{ranges} parameter is set.}

\item{links}{Display links}

\item{tile}{Display per-cell fragment information in sliding windows.}

\item{tile.size}{Size of the sliding window for per-cell fragment tile plot}

\item{tile.cells}{Number of cells to display fragment information for in tile
plot.}

\item{heights}{Relative heights for each track (accessibility, gene
annotations, peaks, links).}

\item{group.by}{Name of one or more metadata columns to group (color) the
cells by. Default is the current cell identities}

\item{window}{Smoothing window size}

\item{extend.upstream}{Number of bases to extend the region upstream.}

\item{extend.downstream}{Number of bases to extend the region downstream.}

\item{scale.factor}{Scaling factor for track height. If NULL (default),
use the median group scaling factor determined by total number of fragments
sequences in each group.}

\item{ymax}{Maximum value for Y axis. If NULL (default) set to the highest
value among all the tracks.}

\item{cells}{Which cells to plot. Default all cells}

\item{idents}{Which identities to include in the plot. Default is all
identities.}

\item{sep}{Separators to use for strings encoding genomic coordinates. First
element is used to separate the chromosome from the coordinates, second
element is used to separate the start from end coordinate.}

\item{max.downsample}{Minimum number of positions kept when downsampling.
Downsampling rate is adaptive to the window size, but this parameter will set
the minimum possible number of positions to include so that plots do not
become too sparse when the window size is small.}

\item{downsample.rate}{Fraction of positions to retain when downsampling.
Retaining more positions can give a higher-resolution plot but can make the
number of points large, resulting in larger file sizes when saving the plot
and a longer period of time needed to draw the plot.}

\item{...}{Additional arguments passed to \code{\link[patchwork]{wrap_plots}}}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot frequency of Tn5 insertion events for different groups of cells within
given regions of the genome.
}
\details{
Thanks to Andrew Hill for providing an early version of this function.
}
\examples{
\donttest{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
fragments <- CreateFragmentObject(
  path = fpath,
  cells = colnames(atac_small),
  validate.fragments = FALSE
)
Fragments(atac_small) <- fragments
CoveragePlot(object = atac_small, region = c("chr1-713500-714500"))
}
}
\concept{visualization}
