rbin <-
  function(clsize,lin.pred,cor.matrix,intercepts,link="probit")
  {
    if(!is.numeric(clsize) | clsize < 2)
      stop("'clsize' must be greater than or equal to two")
    clsize <- as.integer(clsize) 
    lin.pred <- as.matrix(lin.pred)
    if(!is.numeric(lin.pred))
      stop("'lin.pred' must be a numeric")
    if(ncol(lin.pred)!=clsize) 
      stop("'lin.pred' must have ",clsize," columns")
    R <- nrow(lin.pred)
    if(!is.vector(intercepts))
      stop("'intercepts' must be a vector")
    if(!is.numeric(intercepts))
      stop("'intercepts' must be numeric")
    if(length(intercepts)==1) intercepts <- rep(intercepts,clsize)
    if(length(intercepts)!=clsize) 
      stop("'intercepts' must have 1 or ",clsize, " elements")
    intercepts <- cbind(-Inf,intercepts,Inf)
    links <- c("probit","logit","cloglog","cauchit")
    if(!is.element(link,links)) 
      stop("'link' must be either 'probit','logit','cloglog' or'cauchit'") 
    distr <- switch(link,"probit"="normal","logit"="logistic","cloglog"="extreme","cauchit"="cauchit")
    if(!is.numeric(cor.matrix)) 
      stop("'cor.matrix' must be numeric")
    if(!is.matrix(cor.matrix))
      stop("'cor.matrix' must be a matrix")
    if(ncol(cor.matrix)!=clsize | nrow(cor.matrix)!=clsize) 
        stop("'cor.matrix' must be a ",clsize,"x",clsize," matrix")
    if(!isSymmetric(cor.matrix)) 
        stop("'cor.matrix' must be a symmetric matrix") 
    if(any(diag(cor.matrix)!=1)) 
        stop("the diagonal elements of 'cor.matrix' must be one")
    if(any(cor.matrix>1) | any(cor.matrix< -1))
        stop("all the elements of 'cor.matrix' must be on [-1,1]")
    if(any(eigen(cor.matrix,symmetric=TRUE,only.values=TRUE)$values<=0))
        stop("'cor.matrix' must be positive definite")
    err <- rnorta(R=R,cor.matrix=cor.matrix,distr=distr)
    U <- if(distr=="extreme") lin.pred+err else -lin.pred+err
    Ysim <- matrix(0,R,clsize)
    for(i in 1:clsize) Ysim[,i] <- cut(U[,i],intercepts[i,],labels=FALSE)
    Ysim <- 2-Ysim
    list(Ysim=Ysim,correlation=cor.matrix,rlatent=err)
  }