% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aggregate_simulations.R
\name{aggregate_simulations}
\alias{aggregate_simulations}
\title{Collapse seperate simulation files into a single result}
\usage{
aggregate_simulations(files = NULL)
}
\arguments{
\item{files}{a character vector containing the names of the simulation files. If NULL, all files
  in the working directory ending in .rds will be used}
}
\value{
a data.frame with the (weighted) average of the simulation results
}
\description{
This function grabs all .rds files in the working directory and aggregates them into a single
data.frame object. Weights are inferred from the last numbers before .rds, in the form
"name_of_sim_100.rds".
}
\examples{
\dontrun{

setwd('my_working_directory')

final <- aggregate_simulations()
head(final)

saveRDS(final, 'my_final_simulation.rds')

}
}

