% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{bias}
\alias{bias}
\title{Compute (relative) bias summary statistic}
\usage{
bias(observed, population = NULL, relative = FALSE)
}
\arguments{
\item{observed}{a numeric vector or matrix/data.frame of parameter estimates. If a vector,
the length is equal to the number of replications. If a matrix/data.frame,
the number of rows must equal the number of replications}

\item{population}{a numeric scalar/vector indicating the fixed population values.
If a single value is supplied and \code{observed} is a matrix/data.frame then the value will be
recycled for each column.
If NULL, then it will be assumed that the \code{observed} input is in a deviation
form (therefore \code{mean(observed))} will be returned)}

\item{relative}{logical; compute the relative bias statistic? Default is FALSE}
}
\value{
returns a numeric vector indicating the overall (relative) bias in the estimates
}
\description{
Computes the (relative) bias of a sample estimate from the population value.
Accepts observed and population values, as well as observed values which are in deviation form.
If relative bias is requested the \code{observed} and \code{population} inputs are both required.
}
\examples{

pop <- 2
samp <- rnorm(100, 2, sd = 0.5)
bias(samp, pop)
bias(samp, pop, relative = TRUE)

dev <- samp - pop
bias(dev)

# equivalent here
bias(mean(samp), pop)

# matrix input
mat <- cbind(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
bias(mat, population = 2)

# same, but with data.frame
df <- data.frame(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
bias(df, population = c(2,2))


}
\seealso{
\code{\link{RMSE}}
}

