% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{RMSE}
\alias{RMSE}
\title{Compute the (normalized) root mean square error}
\usage{
RMSE(estimate, parameter = NULL, type = "RMSE", MSE = FALSE)
}
\arguments{
\item{estimate}{a \code{numeric} vector or \code{matrix}/\code{data.frame} of parameter estimates.
If a vector, the length is equal to the number of replications. If a
\code{matrix}/\code{data.frame}, the number of rows must equal the number of replications}

\item{parameter}{a \code{numeric} scalar/vector indicating the fixed parameter values.
If a single value is supplied and \code{estimate} is a \code{matrix}/\code{data.frame} then
the value will be recycled for each column.
If \code{NULL} then it will be assumed that the \code{estimate} input is in a deviation
form (therefore \code{sqrt(mean(estimate^2))} will be returned)}

\item{type}{type of deviation to compute. Can be \code{'RMSE'} (default) for the root mean square-error,
\code{'NRMSE'} for the normalized RMSE (RMSE / (max(estimate) - min(estimate))),
\code{'NRMSE_SD'} for the normalized RMSE with the standard deviation (RMSE / sd(estimate)),
\code{'CV'} for the coefficient of variation, or \code{'RMSLE'} for the root mean-square log-error}

\item{MSE}{logical; return the mean square error equivalent of the results instead of the root
mean-square error (in other words, the result is squred)? Default is \code{FALSE}}
}
\value{
returns a \code{numeric} vector indicating the overall average deviation in the estimates
}
\description{
Computes the average deviation (root mean square error; also known as the root mean square deviation)
of a sample estimate from the parameter value. Accepts estimate and parameter values,
as well as estimate values which are in deviation form.
}
\examples{

pop <- 1
samp <- rnorm(100, 1, sd = 0.5)
RMSE(samp, pop)

dev <- samp - pop
RMSE(dev)

RMSE(samp, pop, type = 'NRMSE')
RMSE(dev, type = 'NRMSE')
RMSE(dev, pop, type = 'NRMSE_SD')
RMSE(samp, pop, type = 'CV')
RMSE(samp, pop, type = 'RMSLE')

# matrix input
mat <- cbind(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
RMSE(mat, parameter = 2)

# same, but with data.frame
df <- data.frame(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
RMSE(df, parameter = c(2,2))

}
\seealso{
\code{\link{bias}}

MAE
}

