% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.simul.conc.end.R
\name{graph.simul.conc.end}
\alias{graph.simul.conc.end}
\title{Graphics of simulation ends}
\usage{
graph.simul.conc.end(all_res_sim,new.window=FALSE,add.eq=TRUE,
which.sim=NULL,which.enz=NULL,...)
}
\arguments{
\item{all_res_sim}{List, the output of function \code{\link{simul.evol.enz.multiple}} (results of evolution simulation).}

\item{new.window}{Logical. Do graphics appear in a new window?}

\item{add.eq}{Logical. Do equilibrium appear on graph?}

\item{which.sim}{Numeric vector containing integer numbers between 1 and \code{nsim}. Which simulations would you represent? If \code{NULL} (default), all simulations would be represented.}

\item{which.enz}{Numeric vector containing integer numbers between 1 and \code{n}. Which enzymes would you represent? If \code{NULL} (default), all enzymes would be represented.}

\item{...}{Arguments to be passed in \code{plot} function, such as \code{lwd} or \code{cex}.}
}
\description{
Gives graphics of enzyme concentrations two-by-two at end of simulation
}
\details{
This function shows the concentration of one enzyme against the concentration of another enzyme, for selected enzymes.

Simulation ends are supposed to be near to equilibrium, given the population size and therefore the neutral zone.
}
\examples{

data(data_sim_CRNeg_1grpNeg1sgl)
graph.simul.conc.end(data_sim_CRNeg_1grpNeg1sgl)


}
\seealso{
Use function \code{\link{simul.evol.enz.multiple}} to simulate enzyme evolution.

Use function \code{\link{graph.simul.by.time.by.sim}} to see enzyme concentrations through time.
}
