\name{make.haplo.rare}
\alias{make.haplo.rare}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Group rare haplotypes together}
\description{
  \code{make.haplo.rare} groups haplotypes with frequencies below a specified threshold together and processes data into a format compatible with the haplotype analysis functions}

\usage{
make.haplo.rare(infer.object, min.freq)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{infer.object}{result of a call to \code{infer.haplos}.}
  \item{min.freq}{minimum frequency of haplotypes to include in analysis. Haplotype with a frequency below this value will be grouped together in a group called `rare'.}
}

\value{
  
  \item{hapData}{A data frame containing all haplotype configurations and their posterior probabilities for each individual, grouping rare haplotypes into a category called `rare'.}
  \item{hapObject}{A list containing the original haplotype information for each individual as well as haplotype frequency tables}

}
\references{
McCaskie, P.A., Carter, K.W, Hazelton, M., Palmer, L.J. (2007) SimHap: A comprehensive modeling framework for epidemiological outcomes and a multiple imputation approach to haplotypic analysis of population-based data, [online] www.genepi.org.au/simhap.
}
\author{Pamela A. McCaskie}

\seealso{\code{\link{infer.haplos}}}
\examples{

data(SNP.dat)

# convert SNP.dat to format required by infer.haplos
haplo.dat <- SNP2Haplo(SNP.dat)

data(pheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(haplo.dat) 

# print haplotype frequencies generated by infer.haplos
myinfer$hap.freq 

# generate haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05) 
mymodel <- haplo.quant(formula1=HDL~AGE+SBP+h.N1AA, formula2=HDL~AGE+SBP, 
	pheno=pheno.dat, haplo=myhaplo, sim=10)


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{manip}

