% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_outer.R
\name{run_outer}
\alias{run_outer}
\title{Run \code{SimInf_model} on scaled parameters}
\usage{
run_outer(x, y, model, formula = NULL, FUN = NULL, ...)
}
\arguments{
\item{x}{Scale the model \code{gdata} parameter values on the
right hand side of the formula with \code{x} before calling
\code{FUN} with the scaled model as argument.}

\item{y}{Scale the model \code{gdata} parameter values on the
left hand side of the formula with \code{y} before calling
\code{FUN} with the scaled model as argument.}

\item{model}{The siminf model to scale parameters on and run.}

\item{formula}{The parameters in the \code{gdata} vector matching
the left hand side of the formula \code{a + b ~ c} will be
scaled by \code{y}.  The parameters in the \code{gdata} vector
matching the right hand side of the formula \code{a + b ~ c}
will be scaled by \code{x}.}

\item{FUN}{A function to use on the scaled model 'gdata' parameters.}

\item{...}{Optional arguments to be passed to \code{FUN}.}
}
\value{
Array with dimension \code{c(dim(x), dim(y))}.
}
\description{
Run \code{SimInf_model} on scaled parameters
}
\examples{
\dontrun{
## Create an SIR-model with 500 nodes of 99 susceptible individuals
## and one infected individuals.
u0 <- data.frame(S = rep(99, 500), I = rep(1, 500), R = rep(0, 500))
model <- SIR(u0, 1:75, beta = 0.16, gamma = 0.077)

## Define scaling parameters
x <- seq(from = 0.2, to = 1.8, by = 0.05)
y <- seq(from = 0.2, to = 1.1, by = 0.05)

## Utility function to run the model and estimate the population
## prevalence on day 75.
pop_prev <- function(model) {
    result <- run(model)
    prevalence(result, I~., type = "pop", as.is = TRUE)[75]
}

## Scale 'gamma' with 'y' and 'beta' with 'x' and
## run the model and determine the population prevalence on day
## 500. For each combination of 'x' and 'y', the model parameters
## are scaled and the function 'pop_prev' called with the
## perturbed model.
pop <- run_outer(x, y, model, gamma ~ beta, pop_prev)

## Plot result
contour(x * model@gdata["beta"], y * model@gdata["gamma"],
        pop, method = "edge", bty = "l")

## Utility function to run the model and estimate the node
## prevalence on day 75.
node_prev <- function(model) {
    result <- run(model)
    prevalence(result, I~., type = "nop", as.is = TRUE)[75]
}

## Scale 'gamma' with 'y' and 'beta' with 'x' and
## run the model and determine the node prevalence on day
## 500. For each combination of 'x' and 'y', the model parameters
## are scaled and the function 'node_prev' called with the
## perturbed model.
nop <- run_outer(x, y, model, gamma ~ beta, node_prev)

## Plot result
contour(x * model@gdata["beta"], y * model@gdata["gamma"],
        nop, method = "edge", bty = "l")
}
}
