% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf.R
\docType{package}
\name{SimInf}
\alias{SimInf-package}
\alias{SimInf}
\title{A Framework for Data-Driven Stochastic Disease Spread Simulations}
\description{
The SimInf package provides a flexible framework for data-driven
spatio-temporal disease spread modeling, designed to efficiently
handle population demographics and network data. The framework
integrates infection dynamics in each subpopulation as
continuous-time Markov chains (CTMC) using the Gillespie
stochastic simulation algorithm (SSA) and incorporates available
data such as births, deaths or movements as scheduled events. A
scheduled event is used to modify the state of a subpopulation at
a predefined time-point.
}
\details{
The \code{\linkS4class{SimInf_model}} is central and provides the
basis for the framework. A \code{\linkS4class{SimInf_model}}
object supplies the state-change matrix, the dependency graph, the
scheduled events, and the initial state of the system.

All predefined models in SimInf have a generating function, with
the same name as the model, for example \code{\link{SIR}}.

A model can also be created from a model specification using the
\code{\link{mparse}} method.

After a model is created, a simulation is started with a call to
the \code{\link{run}} method and if execution is successful, it
returns a modified \code{\linkS4class{SimInf_model}} object with a
single stochastic solution trajectory attached to it.

SimInf provides several utility functions to inspect simulated
data, for example, \code{show}, \code{summary} and \code{plot}.
To facilitate custom analysis, it provides the
\code{\link{trajectory,SimInf_model-method}} and
\code{\link{prevalence}} methods.

One of our design goal was to make SimInf extendable and enable
usage of the numerical solvers from other R extension packages in
order to facilitate complex epidemiological research.  To support
this, SimInf has functionality to generate the required C and R
code from a model specification, see
\code{\link{package_skeleton}}
}
\references{
\Widgren2019
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/stewid/SimInf}
  \item Report bugs at \url{https://github.com/stewid/SimInf/issues}
}

}
\author{
\strong{Maintainer}: Stefan Widgren \email{stefan.widgren@gmail.com} (\href{https://orcid.org/0000-0001-5745-2284}{ORCID})

Authors:
\itemize{
  \item Robin Eriksson (\href{https://orcid.org/0000-0002-4291-712X}{ORCID})
  \item Stefan Engblom (\href{https://orcid.org/0000-0002-3614-1732}{ORCID})
  \item Pavol Bauer (\href{https://orcid.org/0000-0003-4328-7171}{ORCID})
}

Other contributors:
\itemize{
  \item Thomas Rosendal (\href{https://orcid.org/0000-0002-6576-9668}{ORCID}) [contributor]
  \item Ivana Rodriguez Ewerlöf (\href{https://orcid.org/0000-0002-9678-9813}{ORCID}) [contributor]
  \item Attractive Chaos (Author of 'kvec.h'.) [copyright holder]
}

}
