% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_fisherk.R
\name{calc_fisherk}
\alias{calc_fisherk}
\title{Find Standardized Cumulants of Data based on Fisher's k-statistics}
\usage{
calc_fisherk(x)
}
\arguments{
\item{x}{a vector of data}
}
\value{
A vector of the mean, standard deviation, skewness, standardized kurtosis, and standardized fifth and sixth cumulants
}
\description{
This function uses Fisher's k-statistics to calculate the mean, standard deviation, skewness,
    standardized kurtosis, and standardized fifth and sixth cumulants given a vector of data.  The result can be used
    as input to \code{\link[SimMultiCorrData]{find_constants}} or for data simulation.
}
\examples{
x <- rgamma(n = 10000, 10, 10)
calc_fisherk(x)
}
\references{
Fisher RA (1928). Moments and Product Moments of Sampling Distributions. Proc. London Math. Soc. 30, 199-238. \doi{10.1112/plms/s2-30.1.199}.

Headrick TC, Sheng Y, & Hodis FA (2007). Numerical Computing and Graphics for the Power Method Transformation Using
    Mathematica. Journal of Statistical Software, 19(3), 1 - 17. \doi{10.18637/jss.v019.i03}
}
\seealso{
\code{\link[SimMultiCorrData]{calc_theory}}, \code{\link[SimMultiCorrData]{calc_moments}},
         \code{\link[SimMultiCorrData]{find_constants}}
}
\keyword{Fisher}
\keyword{cumulants,}
