% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/study_seq_methods.R
\name{summary.famStudy}
\alias{summary.famStudy}
\title{Summary function for objects of class famStudy}
\usage{
\method{summary}{famStudy}(object, ...)
}
\arguments{
\item{object}{An object of class \code{famStudy}, returned by the \code{sim_RVstudy} function.}

\item{...}{additional arguments passed to other methods.}
}
\value{
\item{\code{fam_allele_count} }{A matrix that contains counts of the SNVs shared by the disease-affected relatives in each pedigree.}

\item{\code{pathway_count} }{A data frame that catalogs the SNVs shared among disease-affected study participants. See details.}
}
\description{
Summary function for objects of class \code{famStudy}, i.e. objects returned by the \code{\link{sim_RVstudy}} function.
}
\details{
The \code{summary.famStudy} function returns a list containing two items.  The first item, \code{fam_allele_count}, is a matrix that contains counts of the SNVs shared by the disease-affected relatives in each pedigree. This matrix will contain a row of counts for each pedigree in the supplied \code{famSutdy} object.  The first column in \code{fam_allele_count} is named \code{FamID} and identifies each pedigree by their family identification number.  The remaining columns in \code{fam_allele_count} are named according to the respective marker names of the shared SNVs.

The second item returned by \code{summary.famStudy} is a data frame named \code{pathway_count}, which catalogs the SNVs shared among disease-affected study participants.  This data frame contains the following variables:
\tabular{lll}{
\strong{name} \tab \strong{type} \tab \strong{description} \cr
\code{chrom} \tab numeric \tab chromosome identification number \cr
\code{position} \tab numeric \tab the position of the SNV \cr
\code{marker} \tab character \tab a unique character identifier for the SNV \cr
\code{total} \tab numeric \tab the number of SNV copies observed in disease-affected study participants. \cr
\code{is_crv} \tab logical \tab  identifies causal rare variants (cRVs) as \code{TRUE} \cr
\code{pathwaySNV} \tab logical \tab identifies SNVs located within the pathway of interest as \code{TRUE}. \cr
}

Please note, the variable \code{pathwaySNV} is omitted when missing from the \code{SNV_map} data frame in the \code{famStudy} object. See \code{\link{sim_RVstudy}} for more details.
}
\examples{
library(SimRVSequences)

#load pedigree, haplotype, and mutation data
data(study_peds)
data(EXmuts)
data(EXhaps)

#create variable is_CRV in EXmuts to identify the causal
#rare variants from which to sample familial cRVs.
EXmuts$is_CRV = FALSE
EXmuts$is_CRV[c(26, 139, 223, 228, 472)] = TRUE

#supply required inputs to the sim_RVstudy function
seqDat = sim_RVstudy(ped_files = study_peds,
                     SNV_map = EXmuts,
                     haplos = EXhaps)

#to count the number of SNVs shared by the disease-affected
#relatives in each pedigree, supply the output returned by
#sim_RVstudy to the summary function
summary(seqDat)


}
\seealso{
\code{\link{sim_RVstudy}}
}
