% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist_spde.R
\name{.Q}
\alias{.Q}
\title{Helper function to generate precision matrix Q for simulation}
\usage{
.Q(
  mesh,
  barrier.triangles,
  range = 50,
  range_fraction = 0.2,
  sigma_u = 1,
  model = "spde"
)
}
\arguments{
\item{mesh}{The mesh created by R-INLA representing the spatial area.}

\item{barrier.triangles}{A list of mesh triangles that represent the barrier (used only for the barrier model).}

\item{range}{The decorrelation range.}

\item{range_fraction}{Fraction used to adjust the range across the "land" (barrier) regions. Only used in the barrier model.}

\item{sigma_u}{The overall variance of the spatial process.}

\item{model}{Either \code{"spde"} for the standard SPDE model or \code{"barrier"} for the barrier model.}
}
\value{
A sparse precision matrix \code{Q} of class \code{dgTMatrix}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Creates a precision matrix from a mesh created by \strong{R-INLA}, given a specified
decorrelation range. This function supports both the standard SPDE approach and
the barrier model version. It serves a similar purpose to \code{.sp_covar()}.
}
\keyword{internal}
