% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_sim.R
\name{vis_sim}
\alias{vis_sim}
\title{Make a flexdashboard for visualizing the simulation}
\usage{
vis_sim(sim, ...)
}
\arguments{
\item{sim}{An object produced by \code{\link[=sim_abundance]{sim_abundance()}}, \code{\link[=sim_distribution]{sim_distribution()}},
\code{\link[=sim_survey]{sim_survey()}}, or \code{\link[=test_surveys]{test_surveys()}}.}

\item{...}{Additional arguments passed to \code{\link[rmarkdown:run]{rmarkdown::run()}}.}
}
\value{
No return value. This function launches an interactive dashboard in the Viewer pane or browser.
}
\description{
Launches an interactive flexdashboard to visualize simulation outputs.
Assumes the working directory is the root project directory.
}
\examples{
\donttest{
if (interactive()) {
  pop <- sim_abundance(ages = 1:20, years = 1:20)
  vis_sim(pop)

  dist <- sim_distribution(pop, grid = make_grid(res = c(10, 10)))
  vis_sim(dist)

  # Single survey
  survey <- sim_survey(dist, n_sims = 5)
  vis_sim(survey)

  # Multiple survey designs
  surveys <- expand_surveys(set_den = c(1, 2) / 1000,
                            lengths_cap = c(100, 500),
                            ages_cap = c(5, 20))

  tests <- test_surveys(dist, surveys = surveys, keep_details = 1,
                        n_sims = 5, n_loops = 5, cores = 1)
  vis_sim(tests)
}
}

}
