% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_missing.R
\name{add_missing}
\alias{add_missing}
\title{Add rows for unused combinations of factor levels}
\usage{
add_missing(x, group_cols, defaults)
}
\arguments{
\item{x}{A data.frame or tibble.}

\item{group_cols}{Vector of the names of the grouping columns.}

\item{defaults}{A named list of default values.}
}
\value{
A tibble

A tibble or data.frame, depending on the class of x.
}
\description{
add_missing adds rows for unused combinations of factor levels.

The function takes as input a data.frame or tibble, the column names of 
grouping variables, and a named list of default values.
}
\examples{
iris_sub <- dplyr::filter(iris, Species != "virginica")
iris_summary <- dplyr::group_by(iris_sub, Species)
iris_summary <- dplyr::summarise(iris_summary, N = dplyr::n())
iris_summary <- dplyr::ungroup(iris_summary)
add_missing(iris_summary, "Species", list(N = 0))
}
