% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-overlap-measures.R
\name{PAND}
\alias{PAND}
\title{Percentage of all non-overlapping data (PAND)}
\usage{
PAND(
  A_data,
  B_data,
  condition,
  outcome,
  baseline_phase = unique(condition)[1],
  improvement = "increase"
)
}
\arguments{
\item{A_data}{vector of numeric data for A phase. Missing values are dropped.}

\item{B_data}{vector of numeric data for B phase. Missing values are dropped.}

\item{condition}{vector identifying the treatment condition for each
observation in the series.}

\item{outcome}{vector of outcome data for the entire series.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. Defaults to first
observed value of \code{condition}.}

\item{improvement}{character string indicating direction of improvement.
Default is "increase".}
}
\value{
Numeric value
}
\description{
Calculates the percentage of all non-overlapping data index 
  (Parker, Hagan-Burke, & Vannest, 2007; Parker, Vannest, & Davis, 2011).
}
\details{
For an outcome where increase is desirable, PAND is calculated as
  the proportion of observations remaining after removing the fewest possible
  number of observations from either phase so that the highest remaining
  point from the baseline phase is less than the lowest remaining point from
  the treatment phase. For an outcome where decrease is desirable, PAND is calculated as
  the proportion of observations remaining after removing the fewest possible
  number of observations from either phase so that the lowest remaining
  point from the baseline phase is greater than the highest remaining point from
  the treatment phase. The range of PAND depends on the number of
  observations in each phase.
}
\examples{
A <- c(20, 20, 26, 25, 22, 23)
B <- c(28, 25, 24, 27, 30, 30, 29)
PAND(A_data = A, B_data = B)

}
\references{
Parker, R. I., Hagan-Burke, S., & Vannest, K. J. (2007). 
  Percentage of all non-overlapping data (PAND): An alternative to PND. 
  \emph{The Journal of Special Education, 40}(4), 194--204. 
  doi:\doi{10.1177/00224669070400040101}
  
  Parker, R. I., Vannest, K. J., & Davis, J. L. (2011). Effect size in 
  single-case research: A review of nine nonoverlap techniques. 
  \emph{Behavior Modification, 35}(4), 303--22. 
  doi:\doi{10.1177/0145445511399147}
}
