% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothT.R
\name{simulation_bin}
\alias{simulation_bin}
\title{Generate a symmetric binary tensor from the probability tensor and permutation.}
\usage{
simulation_bin(d, mode = 1)
}
\arguments{
\item{d}{Dimension of a tensor to be generated.}

\item{mode}{An integer from 1 to 5 corresponding to models specified. Default model is 1.}
}
\value{
The returned object is a list of components.

\code{signal} - A true probability tensor generated from a function specified.

\code{observe} - A binary tensor generated by Bernoulli trials given the probability tensor and permutation.

\code{permutation} - A true permutation.
}
\description{
Generate a symmetric binary tensor from the probability tensor and permutation. Users can select one of 5 different smooth probability tensor generated from functions specified in Table 4 of the reference given below.
}
\examples{
d = 20
# Generate 20 by 20 by 20 binary-valued tensor generated from model 1
sim1 = simulation_bin(d, mode = 1)
observed_tensor = sim1$observe
signal_tensor = sim1$signal
permutation = sim1$permutation
}
\references{
C. Lee and M. Wang. Smooth tensor estimation with unknown permutations. arXiv:2105.01783, 2021.
}
