% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is-intact-attr.R
\name{is_intact_attr}
\alias{is_intact_attr}
\alias{is.intact.attributes}
\title{Are Attributes Intact?}
\usage{
is_intact_attr(adat, verbose = interactive())

is.intact.attributes(adat, verbose = interactive())
}
\arguments{
\item{adat}{A \code{soma_adat} object to query.}

\item{verbose}{Logical. Should the function call be run in \emph{verbose}
mode, printing relevant diagnostic call information to the console.}
}
\value{
Logical. \code{TRUE} if all checks pass, otherwise \code{FALSE}.
}
\description{
This function runs a series of checks to determine
if a \code{"soma_adat"} object has a complete
set of attributes. If not, this indicates that the object has
been modified since the initial \code{\link[=read_adat]{read_adat()}} call.
Checks for the presence of both "Header.Meta" and "Col.Meta" in the
attribute names. These entries are added during the
\code{\link[=read_adat]{read_adat()}} call. Specifically, within these sections
it also checks for the presence of the following entries:
\describe{
\item{"Header.Meta" section:}{"HEADER", "COL_DATA", and "ROW_DATA"}
\item{"Col.Meta" section:}{"SeqId", "Target", "Units", and "Dilution"}
}
If any of the above they are altered or missing, \code{FALSE} is returned.
}
\section{Functions}{
\itemize{
\item \code{is.intact.attributes()}: has been superseded by a more convenient, current, tidy syntax.

}}
\examples{
# checking attributes
my_adat <- example_data
is_intact_attr(my_adat)           # TRUE
is_intact_attr(my_adat[, -303L])   # doesn't break atts; TRUE
attributes(my_adat)$Col.Meta$Target <- NULL    # break attributes
is_intact_attr(my_adat, verbose = TRUE)  # FALSE (Target missing)
}
\seealso{
\code{\link[=attributes]{attributes()}}
}
