% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateColMeta.R
\name{updateColMeta}
\alias{updateColMeta}
\title{Update Col.Meta Attribute to Match Annotations Object}
\usage{
updateColMeta(adat, anno)
}
\arguments{
\item{adat}{A \code{soma_adat} data object to update attributes.}

\item{anno}{A \code{tibble} containing analyte-specific annotations
from \code{read_annotations()}}
}
\value{
An identical object to \code{adat} with \code{Col.Meta} updated
to match those in \code{anno}.
}
\description{
Utility to update a provided \code{soma_adat} object's column
metadata to match the annotations object.
}
\details{
Attempts to update the following column metadata in the adat:
\itemize{
\item SomaId
\item Target
\item TargetFullName
\item UniProt
\item Type
\item Organism
\item EntrezGeneSymbol
\item EntrezGeneID
}
}
\examples{
\dontrun{
 anno_tbl     <- read_annotations("path/to/annotations.xlsx")
 adat         <- read_adat("path/to/adat_file.adat")
 updated_adat <- updateColMeta(adat, anno_tbl)
}
}
\author{
Caleb Scheidel
}
