% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/module-repository.R
\docType{methods}
\name{downloadModule}
\alias{downloadModule}
\alias{downloadModule,character,character,character,character-method}
\alias{downloadModule,character,character,character,missing-method}
\alias{downloadModule,character,character,missing,character-method}
\alias{downloadModule,character,character,missing,missing-method}
\title{Download a module from a SpaDES module GitHub repository}
\usage{
downloadModule(name, path, version, repo)

\S4method{downloadModule}{character,character,character,character}(name, path,
  version, repo)

\S4method{downloadModule}{character,character,character,missing}(name, path,
  version)

\S4method{downloadModule}{character,character,missing,missing}(name, path)

\S4method{downloadModule}{character,character,missing,character}(name, path,
  repo)
}
\arguments{
\item{name}{Character string giving the module name.}

\item{path}{Character string giving the location in which to save the downloaded module.}

\item{version}{The module version to download.
               (If not specified, or \code{NA}, the most recent version will be retrieved.)}

\item{repo}{GitHub repository name.
               Default is \code{"PredictiveEcology/SpaDES-modules"},
               which is specified by the global option \code{spades.modulesRepo}.}
}
\value{
Invisibly, a character vector containing a list of extracted files.
}
\description{
Download a .zip file of the module and extract (unzip) it to a user-specified location.
}
\details{
Currently only works with a public GitHub repository, where modules are in
a \code{modules} directory in the root tree on the \code{master} branch.

NOTE: the default is to overwrite any existing files in the case of a conflict.
}
\author{
Alex Chubaty
}

