% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulation.R
\docType{methods}
\name{simInit}
\alias{simInit}
\alias{simInit,ANY,ANY,ANY,ANY,ANY,ANY,ANY,ANY-method}
\alias{simInit,ANY,ANY,ANY,character,ANY,ANY,ANY,ANY-method}
\alias{simInit,list,list,list,list,list,data.frame,ANY,character-method}
\alias{simInit,list,list,list,list,list,data.frame,ANY,missing-method}
\alias{simInit,list,list,list,list,list,data.frame,missing,character-method}
\alias{simInit,list,list,list,list,list,data.frame,missing,missing-method}
\alias{simInit,list,list,list,list,list,missing,ANY,missing-method}
\alias{simInit,list,list,list,list,list,missing,missing,missing-method}
\alias{simInit,list,list,list,list,missing,data.frame,ANY,character-method}
\alias{simInit,list,list,list,list,missing,data.frame,ANY,missing-method}
\alias{simInit,list,list,list,list,missing,data.frame,missing,character-method}
\alias{simInit,list,list,list,list,missing,data.frame,missing,missing-method}
\alias{simInit,list,list,list,list,missing,missing,ANY,character-method}
\alias{simInit,list,list,list,list,missing,missing,ANY,missing-method}
\alias{simInit,list,list,list,list,missing,missing,missing,character-method}
\alias{simInit,list,list,list,list,missing,missing,missing,missing-method}
\alias{simInit,list,list,list,missing,list,data.frame,ANY,character-method}
\alias{simInit,list,list,list,missing,list,data.frame,ANY,missing-method}
\alias{simInit,list,list,list,missing,list,data.frame,missing,character-method}
\alias{simInit,list,list,list,missing,list,data.frame,missing,missing-method}
\alias{simInit,list,list,list,missing,list,missing,ANY,character-method}
\alias{simInit,list,list,list,missing,list,missing,ANY,missing-method}
\alias{simInit,list,list,list,missing,list,missing,missing,character-method}
\alias{simInit,list,list,list,missing,list,missing,missing,missing-method}
\alias{simInit,list,list,list,missing,missing,data.frame,ANY,character-method}
\alias{simInit,list,list,list,missing,missing,data.frame,ANY,missing-method}
\alias{simInit,list,list,list,missing,missing,data.frame,missing,character-method}
\alias{simInit,list,list,list,missing,missing,data.frame,missing,missing-method}
\alias{simInit,list,list,list,missing,missing,missing,ANY,character-method}
\alias{simInit,list,list,list,missing,missing,missing,ANY,missing-method}
\alias{simInit,list,list,list,missing,missing,missing,missing,character-method}
\alias{simInit,list,list,list,missing,missing,missing,missing,missing-method}
\alias{simInit,missing,missing,missing,missing,missing,data.frame,missing,missing-method}
\alias{simInit,missing,missing,missing,missing,missing,missing,missing,missing-method}
\title{Initialize a new simulation}
\usage{
simInit(times, params, modules, objects, paths, inputs, outputs, loadOrder)

\S4method{simInit}{list,list,list,list,list,data.frame,ANY,character}(times,
  params, modules, objects, paths, inputs, outputs, loadOrder)


  \S4method{simInit}{list,list,list,list,list,data.frame,missing,character}(times,
  params, modules, objects, paths, inputs, loadOrder)

\S4method{simInit}{list,list,list,list,list,data.frame,missing,missing}(times,
  params, modules, objects, paths, inputs)


  \S4method{simInit}{list,list,list,list,missing,data.frame,missing,character}(times,
  params, modules, objects, inputs, loadOrder)


  \S4method{simInit}{list,list,list,missing,list,data.frame,missing,character}(times,
  params, modules, paths, inputs, loadOrder)


  \S4method{simInit}{list,list,list,list,missing,data.frame,missing,missing}(times,
  params, modules, objects, inputs)


  \S4method{simInit}{list,list,list,missing,missing,data.frame,missing,character}(times,
  params, modules, inputs, loadOrder)


  \S4method{simInit}{list,list,list,missing,list,data.frame,missing,missing}(times,
  params, modules, paths, inputs)


  \S4method{simInit}{list,list,list,missing,missing,data.frame,missing,missing}(times,
  params, modules, inputs)

\S4method{simInit}{list,list,list,list,list,missing,missing,missing}(times,
  params, modules, objects, paths, inputs)


  \S4method{simInit}{list,list,list,list,missing,missing,missing,character}(times,
  params, modules, objects, inputs, loadOrder)


  \S4method{simInit}{list,list,list,missing,list,missing,missing,character}(times,
  params, modules, paths, inputs, loadOrder)

\S4method{simInit}{list,list,list,list,missing,missing,missing,missing}(times,
  params, modules, objects, inputs)


  \S4method{simInit}{list,list,list,missing,missing,missing,missing,character}(times,
  params, modules, inputs, loadOrder)

\S4method{simInit}{list,list,list,missing,list,missing,missing,missing}(times,
  params, modules, paths, inputs)


  \S4method{simInit}{list,list,list,missing,missing,missing,missing,missing}(times,
  params, modules, inputs)

\S4method{simInit}{list,list,list,list,list,missing,ANY,missing}(times, params,
  modules, objects, paths, outputs)

\S4method{simInit}{list,list,list,list,missing,missing,ANY,character}(times,
  params, modules, objects, outputs, loadOrder)

\S4method{simInit}{list,list,list,missing,list,missing,ANY,character}(times,
  params, modules, paths, outputs, loadOrder)

\S4method{simInit}{list,list,list,list,missing,missing,ANY,missing}(times,
  params, modules, objects, outputs)

\S4method{simInit}{list,list,list,missing,missing,missing,ANY,character}(times,
  params, modules, outputs, loadOrder)

\S4method{simInit}{list,list,list,missing,list,missing,ANY,missing}(times,
  params, modules, paths, outputs)

\S4method{simInit}{list,list,list,missing,missing,missing,ANY,missing}(times,
  params, modules, outputs)

\S4method{simInit}{list,list,list,list,list,data.frame,ANY,missing}(times,
  params, modules, objects, paths, inputs, outputs)

\S4method{simInit}{list,list,list,list,missing,data.frame,ANY,character}(times,
  params, modules, objects, inputs, outputs, loadOrder)

\S4method{simInit}{list,list,list,missing,list,data.frame,ANY,character}(times,
  params, modules, paths, inputs, outputs, loadOrder)

\S4method{simInit}{list,list,list,list,missing,data.frame,ANY,missing}(times,
  params, modules, objects, inputs, outputs)


  \S4method{simInit}{list,list,list,missing,missing,data.frame,ANY,character}(times,
  params, modules, inputs, outputs, loadOrder)

\S4method{simInit}{list,list,list,missing,list,data.frame,ANY,missing}(times,
  params, modules, paths, inputs, outputs)


  \S4method{simInit}{list,list,list,missing,missing,data.frame,ANY,missing}(times,
  params, modules, inputs, outputs)

\S4method{simInit}{ANY,ANY,ANY,character,ANY,ANY,ANY,ANY}(times, params,
  modules, objects, paths, inputs, outputs, loadOrder)


  \S4method{simInit}{missing,missing,missing,missing,missing,data.frame,missing,missing}(times,
  params, modules, objects, paths, inputs, outputs, loadOrder)


  \S4method{simInit}{missing,missing,missing,missing,missing,missing,missing,missing}(inputs,
  outputs)

\S4method{simInit}{ANY,ANY,ANY,ANY,ANY,ANY,ANY,ANY}(times, params, modules,
  objects, paths, inputs, outputs, loadOrder)
}
\arguments{
\item{times}{A named list of numeric simulation start and end times
       (e.g., \code{times=list(start=0.0, end=10.0)}).}

\item{params}{A named list of simulation parameters and their values.}

\item{modules}{A named list of character strings specfying the names
of modules to be loaded for the simulation. Note: the module name
should correspond to the R source file from which the module is loaded.
Example: a module named "caribou" will be sourced form the file
\code{caribou.R}, located at the specified \code{modulePath(simList)} (see below).}

\item{objects}{An optional list of data objects to be used in the simulation.}

\item{paths}{An optional named list with up to 3 named elements, \code{modulePath},
\code{inputPath}, and \code{outputPath}. See details.}

\item{inputs}{A \code{data.frame}. Can specify from 1 to 6
columns with following column names: \code{objectName} (character, required), \code{file} (character),
\code{fun} (character), \code{package} (character), \code{interval} (numeric),
\code{loadTime} (numeric). See \code{?simInit}.
See \code{\link{inputs}} and vignette("ii-modules") section about inputs.}

\item{outputs}{A \code{data.frame}. Can specify from 1 to 5
columns with following column names: \code{objectName} (character, required), \code{file} (character),
\code{fun} (character), \code{package} (character), \code{saveTime} (numeric).
See \code{?simInit}. See \code{\link{outputs}} and vignette("ii-modules") section about outputs.}

\item{loadOrder}{An optional list of module names specfiying the order in
                  which to load the modules. If not specified, the module
                  load order will be determined automatically.}
}
\value{
A \code{simList} simulation object, pre-initialized from values
specified in the arguments supplied.
}
\description{
Create a new simulation object, preloaded with parameters, modules, times, etc.
}
\details{
We implement a discrete event simulation in a more modular fashion so it is
easier to add submodules to the simulation. We use S4 classes and methods,
and use \code{data.table} instead of \code{data.frame} to implement the event
queue (because it is much faster).

\code{paths} specifies the location of the module source files,
the data input files, and the saving output files. If no paths are specified,
default is current working directory.
}
\examples{
\dontrun{
 mySim <- simInit(
   times=list(start=0.0, end=2.0, timeunit="year"),
   params=list(.globals=list(stackName="landscape", burnStats="nPixelsBurned")),
   modules=list("randomLandscapes", "fireSpread", "caribouMovement"),
   paths=list(modulePath=system.file("sampleModules", package="SpaDES"))
 )
 spades(mySim)

# A little more complicated with inputs and outputs
 mapPath <- system.file("maps", package="SpaDES")
 mySim <- simInit(
   times=list(start=0.0, end=2.0, timeunit="year"),
   params=list(.globals=list(stackName="landscape", burnStats="nPixelsBurned")),
   modules=list("randomLandscapes", "fireSpread", "caribouMovement"),
   paths=list(modulePath=system.file("sampleModules", package="SpaDES"),
              outputPath=tempdir()),
   inputs=data.frame(
     files=
       dir(file.path(mapPath), full.names=TRUE, pattern="tif")[1:2],
     functions="raster",
     package="raster",
     loadTime=3,
     stringsAsFactors=FALSE),
   outputs=data.frame(
     expand.grid(objectName=c("caribou","landscape"),
     saveTime=1:2,
     stringsAsFactors = FALSE))
 )
 spades(mySim)
}
}
\author{
Alex Chubaty and Eliot McIntire
}
\references{
Matloff, N. (2011). The Art of R Programming (ch. 7.8.3). San Fransisco, CA: No Starch Press, Inc.. Retrieved from \url{http://www.nostarch.com/artofr.htm}
}
\seealso{
\code{\link{spades}}.
}

