% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{format_number}
\alias{format_number}
\alias{format_number}
\alias{format_number,Column,numeric-method}
\title{format_number}
\usage{
format_number(y, x)

\S4method{format_number}{Column,numeric}(y, x)
}
\arguments{
\item{y}{column to format}

\item{x}{number of decimal place to format to}
}
\description{
Formats numeric column y to a format like '#,###,###.##', rounded to x decimal places,
and returns the result as a string column.
}
\details{
If x is 0, the result has no decimal point or fractional part.
If x < 0, the result will be null.
}
\note{
format_number since 1.5.0
}
\examples{
\dontrun{format_number(df$n, 4)}
}
\seealso{
Other string_funcs: \code{\link{ascii}},
  \code{\link{base64}}, \code{\link{concat_ws}},
  \code{\link{concat}}, \code{\link{decode}},
  \code{\link{encode}}, \code{\link{format_string}},
  \code{\link{initcap}}, \code{\link{instr}},
  \code{\link{length}}, \code{\link{levenshtein}},
  \code{\link{locate}}, \code{\link{lower}},
  \code{\link{lpad}}, \code{\link{ltrim}},
  \code{\link{regexp_extract}},
  \code{\link{regexp_replace}}, \code{\link{reverse}},
  \code{\link{rpad}}, \code{\link{rtrim}},
  \code{\link{soundex}}, \code{\link{substring_index}},
  \code{\link{translate}}, \code{\link{trim}},
  \code{\link{unbase64}}, \code{\link{upper}}
}
