% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{column_collection_functions}
\alias{column_collection_functions}
\alias{to_json,Column-method}
\alias{to_json}
\alias{from_json,Column,characterOrstructType-method}
\alias{from_json}
\alias{array_contains,Column-method}
\alias{array_contains}
\alias{map_keys,Column-method}
\alias{map_keys}
\alias{map_values,Column-method}
\alias{map_values}
\alias{explode,Column-method}
\alias{explode}
\alias{size,Column-method}
\alias{size}
\alias{sort_array,Column-method}
\alias{sort_array}
\alias{posexplode,Column-method}
\alias{posexplode}
\alias{explode_outer,Column-method}
\alias{explode_outer}
\alias{posexplode_outer,Column-method}
\alias{posexplode_outer}
\title{Collection functions for Column operations}
\usage{
array_contains(x, value)

explode(x)

explode_outer(x)

from_json(x, schema, ...)

map_keys(x)

map_values(x)

posexplode(x)

posexplode_outer(x)

size(x)

sort_array(x, asc = TRUE)

to_json(x, ...)

\S4method{to_json}{Column}(x, ...)

\S4method{from_json}{Column,characterOrstructType}(x, schema,
  as.json.array = FALSE, ...)

\S4method{array_contains}{Column}(x, value)

\S4method{map_keys}{Column}(x)

\S4method{map_values}{Column}(x)

\S4method{explode}{Column}(x)

\S4method{size}{Column}(x)

\S4method{sort_array}{Column}(x, asc = TRUE)

\S4method{posexplode}{Column}(x)

\S4method{explode_outer}{Column}(x)

\S4method{posexplode_outer}{Column}(x)
}
\arguments{
\item{x}{Column to compute on. Note the difference in the following methods:
\itemize{
\item \code{to_json}: it is the column containing the struct, array of the structs,
    the map or array of maps.
\item \code{from_json}: it is the column containing the JSON string.
}}

\item{value}{a value to be checked if contained in the column}

\item{schema}{a structType object to use as the schema to use when parsing the JSON string.
Since Spark 2.3, the DDL-formatted string is also supported for the schema.}

\item{...}{additional argument(s). In \code{to_json} and \code{from_json}, this contains
additional named properties to control how it is converted, accepts the same
options as the JSON data source.}

\item{asc}{a logical flag indicating the sorting order.
TRUE, sorting is in ascending order.
FALSE, sorting is in descending order.}

\item{as.json.array}{indicating if input string is JSON array of objects or a single object.}
}
\description{
Collection functions defined for \code{Column}.
}
\details{
\code{to_json}: Converts a column containing a \code{structType}, array of \code{structType},
a \code{mapType} or array of \code{mapType} into a Column of JSON string.
Resolving the Column can fail if an unsupported type is encountered.

\code{from_json}: Parses a column containing a JSON string into a Column of \code{structType}
with the specified \code{schema} or array of \code{structType} if \code{as.json.array} is set
to \code{TRUE}. If the string is unparseable, the Column will contain the value NA.

\code{array_contains}: Returns null if the array is null, true if the array contains
the value, and false otherwise.

\code{map_keys}: Returns an unordered array containing the keys of the map.

\code{map_values}: Returns an unordered array containing the values of the map.

\code{explode}: Creates a new row for each element in the given array or map column.

\code{size}: Returns length of array or map.

\code{sort_array}: Sorts the input array in ascending or descending order according
to the natural ordering of the array elements.

\code{posexplode}: Creates a new row for each element with position in the given array
or map column.

\code{explode}: Creates a new row for each element in the given array or map column.
Unlike \code{explode}, if the array/map is \code{null} or empty
then \code{null} is produced.

\code{posexplode_outer}: Creates a new row for each element with position in the given
array or map column. Unlike \code{posexplode}, if the array/map is \code{null} or empty
then the row (\code{null}, \code{null}) is produced.
}
\note{
to_json since 2.2.0

from_json since 2.2.0

array_contains since 1.6.0

map_keys since 2.3.0

map_values since 2.3.0

explode since 1.5.0

size since 1.5.0

sort_array since 1.6.0

posexplode since 2.1.0

explode_outer since 2.3.0

posexplode_outer since 2.3.0
}
\examples{
\dontrun{
# Dataframe used throughout this doc
df <- createDataFrame(cbind(model = rownames(mtcars), mtcars))
tmp <- mutate(df, v1 = create_array(df$mpg, df$cyl, df$hp))
head(select(tmp, array_contains(tmp$v1, 21), size(tmp$v1)))
tmp2 <- mutate(tmp, v2 = explode(tmp$v1))
head(tmp2)
head(select(tmp, posexplode(tmp$v1)))
head(select(tmp, sort_array(tmp$v1)))
head(select(tmp, sort_array(tmp$v1, asc = FALSE)))
tmp3 <- mutate(df, v3 = create_map(df$model, df$cyl))
head(select(tmp3, map_keys(tmp3$v3)))
head(select(tmp3, map_values(tmp3$v3)))}

\dontrun{
# Converts a struct into a JSON object
df2 <- sql("SELECT named_struct('date', cast('2000-01-01' as date)) as d")
select(df2, to_json(df2$d, dateFormat = 'dd/MM/yyyy'))

# Converts an array of structs into a JSON array
df2 <- sql("SELECT array(named_struct('name', 'Bob'), named_struct('name', 'Alice')) as people")
df2 <- mutate(df2, people_json = to_json(df2$people))

# Converts a map into a JSON object
df2 <- sql("SELECT map('name', 'Bob')) as people")
df2 <- mutate(df2, people_json = to_json(df2$people))

# Converts an array of maps into a JSON array
df2 <- sql("SELECT array(map('name', 'Bob'), map('name', 'Alice')) as people")
df2 <- mutate(df2, people_json = to_json(df2$people))}

\dontrun{
df2 <- sql("SELECT named_struct('date', cast('2000-01-01' as date)) as d")
df2 <- mutate(df2, d2 = to_json(df2$d, dateFormat = 'dd/MM/yyyy'))
schema <- structType(structField("date", "string"))
head(select(df2, from_json(df2$d2, schema, dateFormat = 'dd/MM/yyyy')))
df2 <- sql("SELECT named_struct('name', 'Bob') as people")
df2 <- mutate(df2, people_json = to_json(df2$people))
schema <- structType(structField("name", "string"))
head(select(df2, from_json(df2$people_json, schema)))
head(select(df2, from_json(df2$people_json, "name STRING")))}

\dontrun{
df2 <- createDataFrame(data.frame(
  id = c(1, 2, 3), text = c("a,b,c", NA, "d,e")
))

head(select(df2, df2$id, explode_outer(split_string(df2$text, ","))))
head(select(df2, df2$id, posexplode_outer(split_string(df2$text, ","))))}
}
