% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_clustering.R
\docType{methods}
\name{spark.kmeans}
\alias{spark.kmeans}
\alias{spark.kmeans}
\alias{spark.kmeans,SparkDataFrame,formula-method}
\alias{summary,KMeansModel-method}
\alias{predict,KMeansModel-method}
\alias{write.ml,KMeansModel,character-method}
\title{K-Means Clustering Model}
\usage{
spark.kmeans(data, formula, ...)

\S4method{spark.kmeans}{SparkDataFrame,formula}(data, formula, k = 2,
  maxIter = 20, initMode = c("k-means||", "random"), seed = NULL,
  initSteps = 2, tol = 1e-04)

\S4method{summary}{KMeansModel}(object)

\S4method{predict}{KMeansModel}(object, newData)

\S4method{write.ml}{KMeansModel,character}(object, path, overwrite = FALSE)
}
\arguments{
\item{data}{a SparkDataFrame for training.}

\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', '.', ':', '+', and '-'.
Note that the response variable of formula is empty in spark.kmeans.}

\item{...}{additional argument(s) passed to the method.}

\item{k}{number of centers.}

\item{maxIter}{maximum iteration number.}

\item{initMode}{the initialization algorithm chosen to fit the model.}

\item{seed}{the random seed for cluster initialization.}

\item{initSteps}{the number of steps for the k-means|| initialization mode.
This is an advanced setting, the default of 2 is almost always enough.
Must be > 0.}

\item{tol}{convergence tolerance of iterations.}

\item{object}{a fitted k-means model.}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{the directory where the model is saved.}

\item{overwrite}{overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}
}
\value{
\code{spark.kmeans} returns a fitted k-means model.

\code{summary} returns summary information of the fitted model, which is a list.
        The list includes the model's \code{k} (the configured number of cluster centers),
        \code{coefficients} (model cluster centers),
        \code{size} (number of data points in each cluster), \code{cluster}
        (cluster centers of the transformed data), {is.loaded} (whether the model is loaded
        from a saved file), and \code{clusterSize}
        (the actual number of cluster centers. When using initMode = "random",
        \code{clusterSize} may not equal to \code{k}).

\code{predict} returns the predicted values based on a k-means model.
}
\description{
Fits a k-means clustering model against a SparkDataFrame, similarly to R's kmeans().
Users can call \code{summary} to print a summary of the fitted model, \code{predict} to make
predictions on new data, and \code{write.ml}/\code{read.ml} to save/load fitted models.
}
\note{
spark.kmeans since 2.0.0

summary(KMeansModel) since 2.0.0

predict(KMeansModel) since 2.0.0

write.ml(KMeansModel, character) since 2.0.0
}
\examples{
\dontrun{
sparkR.session()
t <- as.data.frame(Titanic)
df <- createDataFrame(t)
model <- spark.kmeans(df, Class ~ Survived, k = 4, initMode = "random")
summary(model)

# fitted values on training data
fitted <- predict(model, df)
head(select(fitted, "Class", "prediction"))

# save fitted model to input path
path <- "path/to/model"
write.ml(model, path)

# can also read back the saved model and print
savedModel <- read.ml(path)
summary(savedModel)
}
}
\seealso{
\link{predict}, \link{read.ml}, \link{write.ml}
}
