% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routines.R
\name{buildmodelmatrix}
\alias{buildmodelmatrix}
\title{Build the model matrix based on particular data, as required to check for identifiability and existence of the maximum likelihood estimate}
\usage{
buildmodelmatrix(zdat, mX = NULL)
}
\arguments{
\item{zdat}{Data matrix with \eqn{t+1} columns. The first \eqn{t} columns, each corresponding to a particular list,
are 0s and 1s defining the capture histories
observed. The last column is the count of cases with that particular capture history.
List names A, B, ... are constructed if not supplied. Where a capture history is not explicitly listed,
it is assumed that it has zero count.}

\item{mX}{A \eqn{2 \times k} matrix giving the \eqn{k} two-list parameters to be included in the model.
Each column of \code{mX} contains the numbers of the corresponding pair of lists.
If \code{mX = 0}, then all two-list parameters are included. If \code{mX = NULL}, no such parameters are included and
 the main effects model is fitted.}
}
\value{
A list with components as below

\code{modmat} The matrix that maps the parameters in the model (excluding any corresponding to non-overlapping lists) to the log expected value
   of the counts of capture histories that do not contain non-overlapping pairs in the data.

\code{tvec} A vector indexed by the parameters in the model, excluding those corresponding to non-overlapping pairs of lists.  For each parameter
   the vector contains the total count of individuals in all the capture histories that include both the lists indexed by that parameter.

\code{rankdef} The column rank deficiency of the matrix \code{modmat}. If \code{rankdef = 0}, the matrix has full column rank.
}
\description{
This routine builds a model matrix as required by the linear program check \code{\link{checkident}} and checks if the matrix is of full rank.
 In addition, for each individual list, and for each pair of lists included in the model,
  it returns the total count of individuals appearing on the specific list or lists whether or not in combination with other lists.
}
\examples{
data(NewOrl)
buildmodelmatrix(NewOrl, mX=NULL)

}
