% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_matrix.R
\name{adj_list}
\alias{adj_list}
\title{Adjacency list for spatial entropy.}
\usage{
adj_list(dist.mat, dist.breaks)
}
\arguments{
\item{dist.mat}{An upper-triangular matrix of Euclidean distances, as returned by \code{\link[=euclid_dist]{euclid_dist()}}.}

\item{dist.breaks}{A numeric vector with the breaks for the partition of the maximum distance into distance classes.
It must start at 0 and end at the maximum possible distance within the observation area.}
}
\value{
A list of length \code{length(dist.breaks)-1}; each element is an upper-triangular
adjacency matrix as returned by \code{\link[=adj_mat]{adj_mat()}} according to the corresponding distance range.
}
\description{
\code{adj_list} builds a list of adjacency matrices for the computation of Altieri's entropy,
one for each possible distance range within the observation area.
}
\details{
This function is needed for the computation of Altieri's spatial entropy.
After defining the distance classes in which the observation window has to be partitioned,
for each class ad adjacency matrix is constructed. Each adjacency matrix identifies what
pairs of points/areas fall within the specific distance range is the basis
for the computation of the local term of Altieri's spatial entropy.
}
\examples{
dist.breaks=c(0,1,2,5,10*sqrt(2))
dist.mat=euclid_dist(coords_pix(square(10), nrow=10, ncol=10))
my.adj.list=adj_list(dist.mat, dist.breaks)

}
