% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{installTFpython}
\alias{installTFpython}
\title{Install Python dependencies for SpatialDDLS}
\usage{
installTFpython(
  conda = "auto",
  python.version = "3.8",
  tensorflow.version = "2.6",
  install.conda = FALSE,
  miniconda.path = NULL
)
}
\arguments{
\item{conda}{Path to a conda executable. Using \code{"auto"} (by default)
allows \pkg{reticulate} to automatically find an appropriate conda binary.}

\item{python.version}{Python version to be installed in the environment
(\code{"3.8"} by default). We recommend keeping this version as it has
been tested to be compatible with tensorflow 2.6.}

\item{tensorflow.version}{Tensorflow version to be installed in the
environment (\code{"2.6"} by default).}

\item{install.conda}{Boolean indicating if installing miniconda automatically
by using \pkg{reticulate}. If \code{TRUE}, \code{conda} argument is
ignored. \code{FALSE} by default.}

\item{miniconda.path}{If \code{install.conda} is \code{TRUE}, you can set the
path where miniconda will be installed. If \code{NULL}, conda will find
automatically the proper place.}
}
\value{
No return value, called for side effects: installation of conda
environment with a Python interpreter and Tensorflow
}
\description{
This function facilitates the installation of the required Python
dependencies for the SpatialDDLS package. It requires a Python interpreter
with the TensorFlow Python library and its dependencies. It utilizes the
reticulate package and the installer of the tensorflow R package to perform
the installation. Conda environments will be used with the new environment
being named SpatialDDLS-env. This function is intended to simplify the
installation process for SpatialDDLS by automatically installing Miniconda
and creating a new environment named SpatialDDLS-env. For users who wish to
use a different Python or conda environment, see the tensorflow::use_condaenv
function and the package vignettes for more information.
}
\examples{
\dontrun{
notesInstallation <- installTFpython(
  conda = "auto", install.conda = TRUE
)
}

}
