# ifndef CPPAD_OP_INCLUDED
# define CPPAD_OP_INCLUDED

/* --------------------------------------------------------------------------
CppAD: C++ Algorithmic Differentiation: Copyright (C) 2003-07 Bradley M. Bell

CppAD is distributed under multiple licenses. This distribution is under
the terms of the 
                    GNU General Public License Version 2.

A copy of this license is included in the COPYING file of this distribution.
Please visit http://www.coin-or.org/CppAD/ for information on other licenses.
-------------------------------------------------------------------------- */

/*
$begin Op$$ $comment CppAD Developer Documentation$$

$section Compute Values and Derivatives for Taped Operations$$

$childtable%
	cppad/local/abs_op.hpp%
	cppad/local/add_op.hpp%
	cppad/local/acos_op.hpp%
	cppad/local/asin_op.hpp%
	cppad/local/atan_op.hpp%
	cppad/local/div_op.hpp%
	cppad/local/exp_op.hpp%
	cppad/local/log_op.hpp%
	cppad/local/mul_op.hpp%
	cppad/local/sin_cos.hpp%
	cppad/local/sqrt_op.hpp%
	cppad/local/sub_op.hpp
%$$

$end
*/


# include <cppad/local/std_math_ad.hpp>
# include <cppad/local/abs_op.hpp>
# include <cppad/local/add_op.hpp>
# include <cppad/local/asin_op.hpp>
# include <cppad/local/acos_op.hpp>
# include <cppad/local/atan_op.hpp>
# include <cppad/local/div_op.hpp>
# include <cppad/local/exp_op.hpp>
# include <cppad/local/log_op.hpp>
# include <cppad/local/mul_op.hpp>
# include <cppad/local/sin_cos.hpp>
# include <cppad/local/sqrt_op.hpp>
# include <cppad/local/sub_op.hpp>


# endif
