% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReliabilityDiagram.R
\name{ReliabilityDiagram}
\alias{ReliabilityDiagram}
\title{Reliability diagram for probability forecasts}
\usage{
ReliabilityDiagram(probs, obs, bins = 10, nboot = 500, plot = FALSE,
  plot.refin = TRUE, cons.probs = 0.95, attributes = FALSE,
  handle.na = c("na.fail", "use.pairwise.complete"))
}
\arguments{
\item{probs}{vector of N probability forecasts for the event obs=1}

\item{obs}{vector of N binary observations, event/no event are coded as 0/1}

\item{bins}{binning to estimate the calibration function (see Details), default: 10}

\item{nboot}{number of bootstrap resamples to calculate the consistency bars, default: 500}

\item{plot}{logical, whether to plot the reliability diagram, default: FALSE}

\item{plot.refin}{Whether to add the frequency distribution of the forecasts to the reliability diagram. default: TRUE}

\item{cons.probs}{The width of the consitency intervals. default: 0.95. Set to NA for no consistency bars.}

\item{attributes}{locical, whether attributes lines are included in the diagram. default: FALSE}

\item{handle.na}{how should missing values be handled; possible values are 'na.fail' and 'use.pairwise.complete'; default: 'na.fail'}
}
\value{
a data.frame with nrows equal to the number of bins (given by the `bins` argument), with columns: average forecast probability per bin, conditional event frequency per bin, lower and upper limit of the consistency bar per bin, number of forecast probabilities per bin, lower and upper bin limit
}
\description{
Reliability diagram for probability forecasts
}
\details{
To estimate the reliability curve, the unit line is categorised into discrete bins, provided by the `bins` argument. If `bins` is a single number, it specifies the number of equidistant bins. If `bins` is a vector of values between zero and one, these values are used as the bin-breaks.
}
\examples{
data(eurotempforecast)
p <- rowMeans(ens.bin)
ReliabilityDiagram(p, obs.bin, plot=TRUE)
}
\references{
Jolliffe IT, Stephenson DB, eds. (2012): Forecast verification: A practitioner's guide in atmospheric science. John Wiley & Sons, 2012. ISBN: 978-0-470-66071-3
Broecker J, Smith LA (2007): Increasing the Reliability of Reliability Diagrams. Wea. Forecasting, 22, 651--661.  DOI: 10.1175/WAF993.1.
}
