% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_subsample.R
\name{subsample}
\alias{subsample}
\title{Subsampling from a set of splines}
\usage{
subsample(Sp, ss)
}
\arguments{
\item{Sp}{\code{Splinets}-object, a collection of \code{s} splines;}

\item{ss}{vector of integers, the coordinates from \code{1:s};}
}
\value{
An \code{Splinets}-object containing \code{length(ss)} splines that are selected from the input object./
}
\description{
The function constructs a \code{Splinets}-object that is made of subsampled
elements of the input \code{Splinets}-object.
The input objects have to be of the same order and over the same knots.
}
\details{
The output \code{Splinet}-object made of subsampled splines is always is of the regular type, i.e. SLOT \code{type='sp'}.
}
\section{References}{

Liu, X., Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. (2019) "Splinets -- efficient orthonormalization of the B-splines."  <arXiv:1910.07341>.

Podg\eqn{\mbox{\'o}}{o}rski, K. (2021) 
"\code{Splinets} -- splines through the Taylor expansion, their support sets and orthogonal bases." <arXiv:2102.00733>.
}

\examples{
#-----------------------------------------------------#
#---------------------Subsampling---------------------#
#-----------------------------------------------------#

#Example with different support ranges, the 3rd order
n=25; xi=sort(runif(n+2)); xi[1]=0; xi[n+2]=1; k=3
supp=list(t(c(2,12)),t(c(4,20)),t(c(6,25))) #defining support ranges for three splines

#Initial random matrices of the derivative for each spline
set.seed(5)
SS1=matrix(rnorm((supp[[1]][1,2]-supp[[1]][1,1]+1)*(k+1)),ncol=(k+1)) 
SS2=matrix(rnorm((supp[[2]][1,2]-supp[[2]][1,1]+1)*(k+1)),ncol=(k+1)) 
SS3=matrix(rnorm((supp[[3]][1,2]-supp[[3]][1,1]+1)*(k+1)),ncol=(k+1)) 

spl=construct(xi,k,SS1,supp[[1]]) #constructing the first correct spline
nspl=construct(xi,k,SS2,supp[[2]],'CRFC')

#See 'gather' function for more details on what follows
spl=gather(spl,nspl) #the second and the first ones
nspl=construct(xi,k,SS3,supp[[3]],'CRLC')
spl=gather(spl,nspl) #the third is added

#Replicating by subsampling with replacement
sz=length(spl@der)
ss=sample(1:sz,size=10,rep=TRUE)

spl=subsample(spl,ss)
is.splinets(spl)[[1]]

spl@supp
spl@der

#Subsampling without replacements
ss=c(3,8,1)
sspl=subsample(spl,ss)

sspl@supp
sspl@der

is.splinets(sspl)[[1]]

#A single spline sampled from a 'Splinets' object
is.splinets(subsample(sspl,1))

}
\seealso{
\code{\link{is.splinets}} for diagnostic of \code{Splinets}-objects;
\code{\link{construct}} for constructing such a \code{Splinets}-object;
\code{\link{gather}}  for combining \code{Splinets}-objects;
\code{\link{refine}} for refinment of a spline to a larger number of knots;
\code{\link{plot,Splinets-method}} for plotting \code{Splinets}-objects;
}
