% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sft_optim.R
\name{softening.optimized}
\alias{softening.optimized}
\title{Make split softening optimized with Nelder-Mead.}
\usage{
softening.optimized(
  tr,
  d,
  miss.fn,
  verbosity = 0,
  implementation = c("gsl", "R"),
  iteration.count = NULL,
  sft.ini = 1
)
}
\arguments{
\item{tr}{The soft tree}

\item{d}{The data set to be used in intialization for determining data boundaries
and in optimization step to evaluate the objective function on the predictions
on this data set by the soft tree with updated softening parameters.}

\item{miss.fn}{Function to provide the value of the objective function for optimization.

   The function obtains as an argument the matrix of class probabilities
   as returned by \code{\link{predictSoftsplits}}
   when making predictions for the data set \code{d} using the soft tree \code{tr}
   but with some softening parameters reset within optimization procedure.
   The function is expected to return one numeric value;
   this value is minimized by the optimization method.}

\item{verbosity}{The verbosity level configures how many additional information is printed}

\item{implementation}{Indentify implementation of optimizer.}

\item{iteration.count}{Number of optimizer iterations.}

\item{sft.ini}{Parameter of softening used as the initial value for the optimization.

 \describe{
   \item{\code{"gsl"}}{ uses \code{multimin} function from \code{gsl} package.}
   \item{\code{"R"}}{ uses \code{optim} - the standard optimization function in R.}
 }}
}
\value{
The soft tree with the new softening parameters
}
\description{
This softening configures all parameters in the tree
with optimization method Nelder-Mead to minimize the given `miss' function.
}
