% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SystematicDesign.R
\name{SystematicDesign}
\alias{SystematicDesign}
\title{Systematic sampling design}
\usage{
SystematicDesign(pik, EPS = 1e-06)
}
\arguments{
\item{pik}{a vector of inclusion probabilities.}

\item{EPS}{a tolerance parameter. Default value is 1e-6.}
}
\value{
Returns a list including:

\code{samples} a matrix that contains the systematic samples in rows.
The samples have the same length as vector \code{pik} and contains 0s and 1s that specify whether a unit is selected or not in the sample.

\code{probas} a vector that contains the selection probabilities of samples in \code{samples}.
}
\description{
Find the systematic sampling design of an inclusion probabilities vector.
It gives all possible samples and their selection probabilities using the systematic sampling.
}
\examples{
## Vector of inclusion probabilities ##
pik   <- c(0.2,0.3,0.6)
## Find the systematic sampling design of pik ##
SystematicDesign(pik)


}
\references{
Quenouille, M. H. (1949). Approximate Tests of Correlation in time-Series. Royal Statistical Society, Series B Vol. 11, No. 1 (1949), pp. 68-84.

Tille, Y. (2020). Sampling and Estimation from Finite Populations. John Wiley & Sons, 91(4), page 89.
}
\author{
Esther Eustache \email{esther.eustache@unine.ch}
}
