#ifndef STAN_MATH_FWD_CORE_OPERATOR_NOT_EQUAL_HPP
#define STAN_MATH_FWD_CORE_OPERATOR_NOT_EQUAL_HPP

#include <stan/math/fwd/core/fvar.hpp>

namespace stan {
  namespace math {

    /**
     * Return true if the value of the two arguments are not equal as
     * defined by <code>!=</code>.
     *
     * @tparam value and tangent type for variables
     * @param[in] x first argument
     * @param[in] y second argument
     * @return true if the values of the arguments are not equal
     */
    template <typename T>
    inline bool operator!=(const fvar<T>& x, const fvar<T>& y) {
      return x.val_ != y.val_;
    }

    /**
     * Return true if the value of the first argument is not equal to
     * the second argument as defined by <code>!=</code>.
     *
     * @tparam value and tangent type for variables
     * @param[in] x first argument
     * @param[in] y second argument
     * @return true if the value of the first argument is not equal to
     * the second argument
     */
    template <typename T>
    inline bool operator!=(const fvar<T>& x, double y) {
      return x.val_ != y;
    }

    /**
     * Return true if the first argument is not equal to the value of
     * the second argument as defined by <code>!=</code>.
     *
     * @tparam value and tangent type for variables
     * @param[in] x first argument
     * @param[in] y second argument
     * @return true if the first argument is not equal to the value of
     * the second argument
     */
    template <typename T>
    inline bool operator!=(double x, const fvar<T>& y) {
      return x != y.val_;
    }

  }
}
#endif
