% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step_Aic_beta_regression.R
\name{StepBeta}
\alias{StepBeta}
\title{Stepwise model selection for Beta Regression}
\usage{
StepBeta(object, k = 2)
}
\arguments{
\item{object}{Object of class "betareg". If the class is different the function apply the step function in "stats" package}

\item{k}{The penalty parameter used for the criterion, e.g. default is k = 2 which identify the classical AIC. BIC can be obtained as k = log(n)}
}
\value{
The algorithm returns an object of class "betareg"
}
\description{
This function performs a stepwise algorithm to define the best linear predictor according to an user defined criterion (defeault is the Akaike Information Criterion aka AIC).
It works for objects of class "betareg". If the object is different from "betareg" class, the function performs the classical "step" function in "stats" package.
}
\details{
StepBeta is different from step (stats) and stepAIC (MASS) functions; for an object of class "betareg" is impossible to use an algorithm which uses the function extractAIC.
Starting from a full model it provides a backaward procedure where the scope model is the reduced one.

First, StepBeta operates with all the principal effects included in the model; starting from the full model, the algorithm computes all the possible models, it calculates the measure (default is AIC) and it defines as a good predictor the model with lower AIC.

Then, based on the previous results, StepBeta operates adding all the possible interactive effects. As in the first passage, the model choosen by the algorithm is the one whose AIC is the lowest.

During the procedure, StepBeta considers all the possible models which betareg can fit. There are many cases where betareg function falls into error, in these cases the algorithm does not consider the linear predictor which causes the error and it goes forward.
}
\examples{
## Starting from a "betareg" model

## Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) The New S Language.
## Wadsworth & Brooks/Cole. (has iris3 as iris.)


## Prepare the data

library(betareg)
data <- iris
data$Sepal.Length <- data$Sepal.Length/(max(data$Sepal.Length) + 0.01)


fullModel <- betareg(Sepal.Length ~ Sepal.Width * Petal.Length *
                                    Petal.Width * Species, data = data)
reducedModel <- StepBeta(fullModel)

summary(reducedModel)

}
\references{
Cribari-Neto, F., and Zeileis, A. (2010). Beta Regression in R. Journal of Statistical Software, 34(2), 1--24. 10.18637/jss.v034.i02

Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.

Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) The New S Language. Wadsworth & Brooks/Cole. (has iris3 as iris.)
}
\author{
Sergio Garofalo
}
