% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lai_forcing.R
\name{get_lai_forcing}
\alias{get_lai_forcing}
\title{Getting LAI forcing for each usm}
\usage{
get_lai_forcing(usm_file_path, usms_list = c())
}
\arguments{
\item{usm_file_path}{Path to usms.xml file}

\item{usms_list}{Usm(s) name(s) (optional, see details)}
}
\value{
A named numeric vector with a Boolean value (\code{TRUE = forced})
for each usm
}
\description{
Is LAI forced for usms in usms.xml
}
\details{
Use \code{get_usms_list()} to get the list of the usm names for an
usms.xml file.
}
\examples{
# Xml case
xml_usms <- file.path(get_examples_path(file_type = "xml"), "usms.xml")
get_lai_forcing(xml_usms)
get_lai_forcing(xml_usms, "wheat")
get_lai_forcing(xml_usms, c("wheat", "intercrop_pea_barley"))


}
